' multicolumn listbox.bmx

SuperStrict

Framework Openb3d.B3dglgraphics

Import Brl.FreeTypeFont

Import Ifsogui.GUI
Import Ifsogui.Panel
Import Ifsogui.Window
Import Ifsogui.Label
Import Ifsogui.Listbox
Import Ifsogui.Checkbox
Import Ifsogui.Button
Import Ifsogui.Mclistbox

'Incbin "Skins.zip" ' Note: there is only one skin
Include "incbinSkin.bmx"

Local sample:TSample=New TSample

sample.Init3D()
sample.InitGUI()

While Not KeyDown(KEY_ESCAPE)

	sample.Update3D()
	
	BeginMax2D()
	sample.UpdateGUI()
	EndMax2D()
	
	Flip 0
	Cls
	
Wend
End


Type TSample

	Field camera:TCamera
	Field light:TLight
	Field cube:TMesh, tex:TTexture
	Field cone:TMesh, tex2:TTexture
	
	Field panel:ifsoGUI_Panel
	Field label:ifsoGUI_Label
	Field checkbox:ifsoGUI_CheckBox
	Field window:ifsoGUI_Window
	Global lstEvents:ifsoGUI_ListBox
	Field button:ifsoGUI_Button
	Global mcl:ifsoGUI_MCListBox
	Global buttonG:ifsoGUI_Button
	
	Field iFPSCounter:Int, iFPSTime:Int, iFPS:Int ' FPS Counter
	Field efx%=1
	
	Method Init3D()
	
		Graphics3D DesktopWidth(),DesktopHeight(),0,2
		
		camera=CreateCamera()
		CameraClsColor camera,80,160,240
		
		light=CreateLight()
		
		cube=CreateCube()
		PositionEntity cube,1.5,0,4
		tex=LoadTexture("../media/alpha_map.png")
		EntityTexture(cube,tex)
		EntityFX(cube,32)
		
		cone=CreateCone()
		PositionEntity cone,0,0,10
		ScaleEntity cone,4,4,4
		tex2=LoadTexture("../media/sand.bmp")
		EntityTexture(cone,tex2)
		
	End Method
	
	Method InitGUI()
	
		GUI.SetResolution(DesktopWidth(), DesktopHeight())
		GUI.SetUseIncBin(True)
		'GUI.SetZipInfo("Skins.zip", "")
		GUI.LoadTheme("Skin2")
		GUI.SetDefaultFont(LoadImageFont(GUI.FileHeader + "Skin2/fonts/arial.ttf", 12))
		GUI.SetDrawMouse(True)
		
		'Status Panel
		panel:ifsoGUI_Panel = ifsoGUI_Panel.Create(650, 480, 140, 110, "StatusPanel")
		GUI.AddGadget(panel)
		panel.AddChild(ifsoGUI_Label.Create(5, 5, 100, 20, "FPSLabel"))
		
		label:ifsoGUI_Label = ifsoGUI_Label.Create(5, 30, 100, 20, "EventCount")
		label.SetLabel("List Items: 0")
		panel.AddChild(label)
		
		checkbox:ifsoGUI_CheckBox = ifsoGUI_CheckBox.Create(5, 55, 100, 20, "chkTop", "Always On Top")
		checkbox.SetLabelClick(True)
		checkbox.SetTip("Sets this Status Panel Always on Top")
		panel.AddChild(checkbox)
		checkbox = ifsoGUI_CheckBox.Create(5, 80, 100, 20, "chkSkin", "Skin 2")
		checkbox.SetLabelClick(True)
		checkbox.SetTip("Use alternate skin?")
		checkbox.SetValue(False)
		panel.AddChild(checkbox)
		
		'Event Window
		window:ifsoGUI_Window = ifsoGUI_Window.Create(10, 400, 550, 190, "EventPanel")
		window.SetCaption("Events")
		window.SetDragTop(True)
		GUI.AddGadget(window)
		
		lstEvents:ifsoGUI_ListBox = ifsoGUI_ListBox.Create(5, 5, 400, window.GetClientHeight() - 10, "EventsList")
		lstEvents.SetHScrollbar(ifsoGUI_SCROLLBAR_AUTO)
		lstEvents.SetMultiSelect(True)
		lstEvents.SetMouseHighlight(True)
		window.AddChild(lstEvents)
		checkbox = ifsoGUI_CheckBox.Create(410, 5, 120, 20, "chkMouseMove", "Mouse Move")
		checkbox.SetLabelClick(True)
		checkbox.SetTip("Show Mouse Move events in the list")
		window.AddChild(checkbox)
		checkbox = ifsoGUI_CheckBox.Create(410, 30, 120, 20, "chkMouseEnter", "Mouse Enter/Exit")
		checkbox.SetLabelClick(True)
		checkbox.SetTip("Show Mouse Enter/Exit events in the list")
		window.AddChild(checkbox)
		checkbox = ifsoGUI_CheckBox.Create(410, 55, 120, 20, "chkListEvents", "Event List Events")
		checkbox.SetLabelClick(True)
		checkbox.SetTip("Show events generated by the event listbox")
		window.AddChild(checkbox)
		checkbox = ifsoGUI_CheckBox.Create(410, 80, 120, 20, "chkFocus", "Gain/Lose Focus")
		checkbox.SetLabelClick(True)
		checkbox.SetTip("Show Focus events in the list")
		window.AddChild(checkbox)
		
		button:ifsoGUI_Button = ifsoGUI_Button.Create(465, 135, 75, 25, "btnClearList", "Clear List")
		button.SetTip("Clears the event list")
		window.AddChild(button)
		
		'Control Window 1
		window = ifsoGUI_Window.Create(20, 20, 580, 360, "ControlsPanel1")
		window.SetCaption("Controls")
		window.SetDragTop(True)
		'window.SetMinWH(150, 150)
		window.SetResizable(True)
		GUI.AddGadget(window)
		checkbox = ifsoGUI_CheckBox.Create(400, 5, -1, 20, "chkBorder", "Show Border")
		checkbox.SetValue(True)
		window.AddChild(checkbox)
		checkbox = ifsoGUI_CheckBox.Create(400, 30, -1, 20, "chkColHead", "Show Column Headers")
		checkbox.SetValue(True)
		window.AddChild(checkbox)
		checkbox = ifsoGUI_CheckBox.Create(400, 55, -1, 20, "chkRowHead", "Show Row Headers")
		checkbox.SetValue(True)
		window.AddChild(checkbox)
		checkbox = ifsoGUI_CheckBox.Create(400, 80, -1, 20, "chkGrid", "Show Grid")
		checkbox.SetValue(True)
		window.AddChild(checkbox)
		checkbox = ifsoGUI_CheckBox.Create(400, 105, -1, 20, "chkScroll", "Show Scrollbars")
		checkbox.SetValue(True)
		checkbox.LoadSkin("Skin2")
		window.AddChild(checkbox)
		
		mcl:ifsoGUI_MCListBox = ifsoGUI_MCListBox.Create(5, 5, 360, 320, "MCListBox")
		mcl.SetShowColumnHeaders(True)
		mcl.SetShowRowHeaders(True)
		mcl.SetShowGrid(True)
		mcl.SetColumnsResizable(True)
		mcl.SetMultiSelect(True)
		
		mcl.AddColumn("Column 1", 30, ifsoGUI_COLUMNTYPE_CHECKBOX, "0")
		mcl.SetColumnMinMaxWidth(0, 30, 130)
		mcl.SetColumnCellAlign(0, ifsoGUI_JUSTIFY_CENTER)
		
		mcl.AddColumn("Column 2", 140, ifsoGUI_COLUMNTYPE_TEXTBOX, "Textbox test")
		mcl.SetColumnMinMaxWidth(1, 10, 200)
		mcl.SetColumnHeaderAlign(1, ifsoGUI_JUSTIFY_CENTER)
		mcl.SetColumnCellAlign(1, ifsoGUI_JUSTIFY_CENTER)
		'mcl.SetColumnShowGadgets(1, True)
		mcl.SetColumnShowBorder(1, True)
		
		mcl.AddColumn("Column 3", 140, ifsoGUI_COLUMNTYPE_SLIDER, "0")
		mcl.SetColumnMinMaxWidth(2, 10, 200)
		mcl.SetColumnHeaderAlign(2, ifsoGUI_JUSTIFY_RIGHT)
		mcl.SetColumnCellAlign(2, ifsoGUI_JUSTIFY_RIGHT)
		
		mcl.AddColumn("Column 4", 140, ifsoGUI_COLUMNTYPE_PROGRESSBAR, "0")
		mcl.SetColumnMinMaxWidth(3, 50, 200)
		mcl.SetColumnShowBorder(3, False)
		mcl.SetColumnBarColor(3, 255, 0, 0)
		mcl.SetColumnMinMax(3, 0, 10)
		
		mcl.AddColumn("Column 5", 140, ifsoGUI_COLUMNTYPE_COMBOBOX, "0")
		mcl.SetColumnMinMaxWidth(4, 50, 200)
		'mcl.SetColumnShowGadgets(4, True)
		mcl.AddComboboxItem(4, "Test", 1, "")
		mcl.AddComboboxItem(4, "Item #2", 2, "")
		mcl.SetColumnShowComboboxData(4, ifsoGUI_COMBOBOX_NAME)
		'mcl.SetColumnReadOnly(4, True)
		
		For Local i:Int = 0 To 24
			mcl.AddRow()
		Next
		
		mcl.SetCellValueInt(4, 1, 0)
		mcl.SetCellValueString(4, 0, "1")
		mcl.SetCellValueString(1, 1, "Whoohoo")
		
		window.AddChild(mcl)
		
		buttonG:ifsoGUI_Button = ifsoGUI_Button.Create(600, 10, 80, 25, "gButton", "Skin")
		buttonG.SetCallBack(cbk)
		GUI.AddGadget(buttonG)
		
		SetClsColor(200, 200, 200)
		
	End Method
	
	Method Update3D()
	
		' turn cube
		If KeyDown(KEY_LEFT)
			TurnEntity cube,0,-0.5,0.1
		EndIf
		If KeyDown(KEY_RIGHT)
			TurnEntity cube,0,0.5,-0.1
		EndIf
		If KeyHit(KEY_B)
			efx=Not efx
			If efx Then EntityFX(cube,32) Else EntityFX(cube,0)
		EndIf
		
		RenderWorld
		
		Text DesktopWidth()-380,20,"Left/Right: turn cube"+", B: alpha blending = "+efx
		
	End Method
	
	Method UpdateGUI()
	
		CheckEvents()
		GUI.Refresh()
		iFPSCounter:+1
		If MilliSecs() - iFPSTime > 1000
			iFPS = iFPSCounter
			iFPSTime = MilliSecs()
			iFPSCounter = 0
			ifsoGUI_Label(GUI.GetGadget("FPSLabel")).SetLabel("FPS: " + iFPS)
		End If
		
	End Method
	
	Function CheckEvents()
	
		Local e:ifsoGUI_Event
		Global SortColumn:Int = -1, bDesc:Int
		Repeat
			e = GUI.GetEvent()
			If Not e Exit
			If e.gadget = lstEvents And Not ifsoGUI_CheckBox(GUI.GetGadget("chkListEvents")).GetValue() Continue
			
			If e.gadget.Name = "btnClearList" And e.id = ifsoGUI_EVENT_CLICK
				lstEvents.RemoveAll()
				ifsoGUI_Label(GUI.GetGadget("EventCount")).SetLabel("List Items: 0")
				Continue
			ElseIf e.gadget.Name = "chkTop" And e.id = ifsoGUI_EVENT_CHANGE
				ifsoGUI_Panel(GUI.GetGadget("StatusPanel")).SetAlwaysOnTop(e.data)
			ElseIf e.gadget.Name = "chkSkin" And e.id = ifsoGUI_EVENT_CHANGE
				If ifsoGUI_CheckBox(e.gadget).GetValue()
					DebugLog "Skin not found"
					'GUI.LoadTheme("Skin")
				Else
					GUI.LoadTheme("Skin2")
				End If
			ElseIf e.gadget.Name = "chkBorder" And e.id = ifsoGUI_EVENT_CHANGE
				mcl.SetShowBorder(ifsoGUI_CheckBox(e.gadget).GetValue())
			ElseIf e.gadget.Name = "chkColHead" And e.id = ifsoGUI_EVENT_CHANGE
				mcl.SetShowColumnHeaders(ifsoGUI_CheckBox(e.gadget).GetValue())
			ElseIf e.gadget.Name = "chkRowHead" And e.id = ifsoGUI_EVENT_CHANGE
				mcl.SetShowRowHeaders(ifsoGUI_CheckBox(e.gadget).GetValue())
			ElseIf e.gadget.Name = "chkGrid" And e.id = ifsoGUI_EVENT_CHANGE
				mcl.SetShowGrid(ifsoGUI_CheckBox(e.gadget).GetValue())
			ElseIf e.gadget.Name = "chkScroll" And e.id = ifsoGUI_EVENT_CHANGE
				mcl.SetVScrollbar(ifsoGUI_CheckBox(e.gadget).GetValue())
				mcl.SetHScrollbar(ifsoGUI_CheckBox(e.gadget).GetValue())
			ElseIf e.gadget = mcl And (e.id = ifsoGUI_EVENT_RESIZE Or e.id = ifsoGUI_EVENT_CLICK Or e.id = ifsoGUI_EVENT_CHANGE Or e.id = ifsoGUI_EVENT_CELL_CHANGE)
			
				Select e.id
					Case ifsoGUI_EVENT_RESIZE
						AddEvent("NAME: MCListBox: Resize Column " + e.data, e.id)
					Case ifsoGUI_EVENT_CLICK
						If e.y = -2 'Clicked a header button
							If e.x = SortColumn
								bDesc = Not bDesc
							Else
								bDesc = False
							End If
							SortColumn = e.x
							mcl.SortList(SortColumn, bDesc)
						End If
						AddEvent("NAME: MCListBox: Click Column " + e.x + " Row " + e.y + " Button " + e.data, e.id)
					Case ifsoGUI_EVENT_CHANGE
						AddEvent("NAME: MCListBox: Change Selected Row", e.id)
					Case ifsoGUI_EVENT_CELL_CHANGE
						If e.x = 2
							mcl.SetCellValueInt(3, e.y, e.data)
						End If
						AddEvent("NAME: MCListBox: Cell Changed Col " + e.x + " Row " + e.y, e.id)
				End Select
				
				Continue
			End If
			
			Select e.id
				Case ifsoGUI_EVENT_MOUSE_MOVE
					If Not ifsoGUI_CheckBox(GUI.GetGadget("chkMouseMove")).GetValue() Continue
				Case ifsoGUI_EVENT_MOUSE_ENTER, ifsoGUI_EVENT_MOUSE_EXIT
					If Not ifsoGUI_CheckBox(GUI.GetGadget("chkMouseEnter")).GetValue() Continue
				Case ifsoGUI_EVENT_GAIN_FOCUS, ifsoGUI_EVENT_LOST_FOCUS
					If Not ifsoGUI_CheckBox(GUI.GetGadget("chkFocus")).GetValue() Continue
			End Select
			
			AddEvent("NAME: " + e.gadget.Name + " EVENT: " + e.EventString(e.id) + " DATA: " + e.data, e.id)
		Forever
		
	End Function
	
	Function cbk(gadget:ifsoGUI_Base, id:Int, data:Int, mX:Int, mY:Int)
	
		Global a:Int
		Global b:ifsoGUI_Base = GUI.GetGadget("MCListBox")
		If id = ifsoGUI_EVENT_CLICK
			a:+1
			If a Mod 2 = 1
				DebugLog "Skin not found"
				'b.LoadSkin("Skin")
			Else
				b.LoadSkin("Skin2")
			End If
		End If
		
	End Function
	
	Function AddEvent(txt:String, id:Int)
	
		lstEvents.AddItem(txt)
		lstEvents.SetTopItem(lstEvents.Items.Length)
		lstEvents.SetItemTip(lstEvents.GetCount() - 1, ifsoGUI_Event.EventString(id))
		ifsoGUI_Label(GUI.GetGadget("EventCount")).SetLabel("List Items: " + lstEvents.GetCount())
		
	End Function
	
End Type
